/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.calendar;

import de.willuhn.jameica.gui.calendar.AppointmentProvider;
import de.willuhn.jameica.plugin.Plugin;
import de.willuhn.jameica.plugin.PluginLoader;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Settings;
import de.willuhn.logging.Logger;
import de.willuhn.util.ClassFinder;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class AppointmentProviderRegistry {
    private static final Settings settings = new Settings(AppointmentProviderRegistry.class);
    private static final Map<Plugin, List<Class<AppointmentProvider>>> cache = new HashMap<Plugin, List<Class<AppointmentProvider>>>();

    public static final List<AppointmentProvider> getAppointmentProviders(Plugin plugin) {
        List<Class<AppointmentProvider>> list = cache.get(plugin);
        if (list == null) {
            list = new LinkedList<Class<AppointmentProvider>>();
            cache.put(plugin, list);
            ClassFinder finder = Application.getClassLoader().getClassFinder();
            PluginLoader loader = Application.getPluginLoader();
            if (plugin != null) {
                finder = plugin.getManifest().getClassLoader().getClassFinder();
            }
            try {
                Class[] classes;
                for (Class c : classes = finder.findImplementors(AppointmentProvider.class)) {
                    Plugin p;
                    if (plugin != null && ((p = loader.findByClass(c)) == null || p != plugin)) continue;
                    try {
                        list.add(c);
                    }
                    catch (Exception e) {
                        Logger.error((String)("unable to load appointment provider " + c + ", skipping"), (Throwable)e);
                    }
                }
            }
            catch (ClassNotFoundException e) {
                Logger.debug((String)"no appointment providers found");
            }
        }
        BeanService beanService = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
        LinkedList<AppointmentProvider> result = new LinkedList<AppointmentProvider>();
        for (Class<AppointmentProvider> c : list) {
            result.add(beanService.get(c));
        }
        return result;
    }

    public static boolean isEnabled(AppointmentProvider provider) {
        if (provider == null) {
            Logger.warn((String)"no provider given");
            return false;
        }
        return settings.getBoolean(provider.getClass().getName() + ".enabled", true);
    }

    public static void setEnabled(AppointmentProvider provider, boolean enabled) {
        if (provider == null) {
            Logger.warn((String)"no provider given");
            return;
        }
        settings.setAttribute(provider.getClass().getName() + ".enabled", enabled);
    }
}

